/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.oer.its;

import org.bouncycastle.asn1.ASN1EncodableVector;
import org.bouncycastle.asn1.ASN1Object;
import org.bouncycastle.asn1.ASN1OctetString;
import org.bouncycastle.asn1.ASN1Primitive;
import org.bouncycastle.asn1.ASN1Sequence;
import org.bouncycastle.asn1.DEROctetString;
import org.bouncycastle.asn1.DERSequence;
import org.bouncycastle.util.Arrays;

public class SequenceOfOctetString
extends ASN1Object {
    private byte[][] octetStrings;

    private SequenceOfOctetString(ASN1Sequence aSN1Sequence) {
        this.octetStrings = SequenceOfOctetString.toByteArrays(aSN1Sequence);
    }

    public static SequenceOfOctetString getInstance(Object object) {
        if (object instanceof SequenceOfOctetString) {
            return (SequenceOfOctetString)object;
        }
        if (object != null) {
            return new SequenceOfOctetString(ASN1Sequence.getInstance(object));
        }
        return null;
    }

    static byte[][] toByteArrays(ASN1Sequence aSN1Sequence) {
        byte[][] byArrayArray = new byte[aSN1Sequence.size()][];
        for (int i2 = 0; i2 != aSN1Sequence.size(); ++i2) {
            byArrayArray[i2] = ASN1OctetString.getInstance(aSN1Sequence.getObjectAt(i2)).getOctets();
        }
        return byArrayArray;
    }

    public int size() {
        return this.octetStrings.length;
    }

    public ASN1Primitive toASN1Primitive() {
        ASN1EncodableVector aSN1EncodableVector = new ASN1EncodableVector();
        for (int i2 = 0; i2 != this.octetStrings.length; ++i2) {
            aSN1EncodableVector.add(new DEROctetString(Arrays.clone(this.octetStrings[i2])));
        }
        return new DERSequence(aSN1EncodableVector);
    }
}

