/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.oer.its;

import org.bouncycastle.asn1.ASN1Choice;
import org.bouncycastle.asn1.ASN1Encodable;
import org.bouncycastle.asn1.ASN1Object;
import org.bouncycastle.asn1.ASN1Primitive;
import org.bouncycastle.asn1.ASN1TaggedObject;
import org.bouncycastle.asn1.DEROctetString;
import org.bouncycastle.asn1.DERTaggedObject;
import org.bouncycastle.oer.its.HashAlgorithm;
import org.bouncycastle.oer.its.HashedId;

public class IssuerIdentifier
extends ASN1Object
implements ASN1Choice {
    public static final int sha256AndDigest = 0;
    public static final int self = 1;
    public static final int extension = 2;
    public static final int sha384AndDigest = 3;
    private final int choice;
    private final ASN1Encodable value;

    public IssuerIdentifier(int n2, ASN1Encodable aSN1Encodable) {
        this.choice = n2;
        this.value = aSN1Encodable;
    }

    public static IssuerIdentifier getInstance(Object object) {
        if (object instanceof IssuerIdentifier) {
            return (IssuerIdentifier)object;
        }
        ASN1TaggedObject aSN1TaggedObject = ASN1TaggedObject.getInstance(object);
        int n2 = aSN1TaggedObject.getTagNo();
        switch (n2) {
            case 0: {
                return new IssuerIdentifier(0, HashedId.HashedId8.getInstance(aSN1TaggedObject.getObject()));
            }
            case 1: {
                return new IssuerIdentifier(1, HashAlgorithm.getInstance(aSN1TaggedObject.getObject()));
            }
            case 2: {
                return new IssuerIdentifier(2, DEROctetString.getInstance(aSN1TaggedObject.getObject()));
            }
            case 3: {
                return new IssuerIdentifier(3, HashedId.HashedId8.getInstance(aSN1TaggedObject.getObject()));
            }
        }
        throw new IllegalArgumentException("unable to decode into known choice" + n2);
    }

    public static Builder builder() {
        return new Builder();
    }

    public boolean isSelf() {
        return this.choice == 1;
    }

    public int getChoice() {
        return this.choice;
    }

    public ASN1Encodable getValue() {
        return this.value;
    }

    public ASN1Primitive toASN1Primitive() {
        return new DERTaggedObject(this.choice, this.value);
    }

    public static class Builder {
        public int choice;
        public ASN1Encodable value;

        public Builder setChoice(int n2) {
            this.choice = n2;
            return this;
        }

        public Builder setValue(ASN1Encodable aSN1Encodable) {
            this.value = aSN1Encodable;
            return this;
        }

        public Builder sha256AndDigest(HashedId hashedId) {
            this.choice = 0;
            this.value = hashedId;
            return this;
        }

        public Builder self(HashAlgorithm hashAlgorithm) {
            this.choice = 1;
            this.value = hashAlgorithm;
            return this;
        }

        public Builder extension(byte[] byArray) {
            this.choice = 2;
            this.value = new DEROctetString(byArray);
            return this;
        }

        public Builder sha384AndDigest(HashedId hashedId) {
            this.choice = 3;
            this.value = hashedId;
            return this;
        }

        public IssuerIdentifier createIssuerIdentifier() {
            return new IssuerIdentifier(this.choice, this.value);
        }
    }
}

