/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.oer.its;

import org.bouncycastle.asn1.ASN1Choice;
import org.bouncycastle.asn1.ASN1Encodable;
import org.bouncycastle.asn1.ASN1Object;
import org.bouncycastle.asn1.ASN1Primitive;
import org.bouncycastle.asn1.ASN1TaggedObject;
import org.bouncycastle.asn1.DEROctetString;
import org.bouncycastle.asn1.DERTaggedObject;
import org.bouncycastle.oer.its.CircularRegion;
import org.bouncycastle.oer.its.PolygonalRegion;
import org.bouncycastle.oer.its.SequenceOfIdentifiedRegion;
import org.bouncycastle.oer.its.SequenceOfRectangularRegion;

public class GeographicRegion
extends ASN1Object
implements ASN1Choice {
    public static final int circularRegion = 0;
    public static final int rectangularRegion = 1;
    public static final int polygonalRegion = 2;
    public static final int identifiedRegion = 3;
    public static final int extension = 4;
    private int choice;
    private ASN1Encodable region;

    public GeographicRegion(int n2, ASN1Encodable aSN1Encodable) {
        this.choice = n2;
        this.region = aSN1Encodable;
    }

    public static GeographicRegion getInstance(Object object) {
        if (object instanceof GeographicRegion) {
            return (GeographicRegion)object;
        }
        ASN1TaggedObject aSN1TaggedObject = ASN1TaggedObject.getInstance(object);
        int n2 = aSN1TaggedObject.getTagNo();
        switch (n2) {
            case 0: {
                return new GeographicRegion(n2, CircularRegion.getInstance(aSN1TaggedObject.getObject()));
            }
            case 1: {
                return new GeographicRegion(n2, SequenceOfRectangularRegion.getInstance(aSN1TaggedObject.getObject()));
            }
            case 2: {
                return new GeographicRegion(n2, PolygonalRegion.getInstance(aSN1TaggedObject.getObject()));
            }
            case 3: {
                return new GeographicRegion(n2, SequenceOfIdentifiedRegion.getInstance(aSN1TaggedObject.getObject()));
            }
            case 4: {
                return new GeographicRegion(n2, DEROctetString.getInstance(aSN1TaggedObject.getObject()));
            }
        }
        throw new IllegalStateException("unknown region choice " + n2);
    }

    public int getChoice() {
        return this.choice;
    }

    public ASN1Encodable getRegion() {
        return this.region;
    }

    public ASN1Primitive toASN1Primitive() {
        return new DERTaggedObject(this.choice, this.region);
    }
}

