/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.oer;

import java.io.IOException;
import java.io.OutputStream;
import java.math.BigInteger;
import org.bouncycastle.util.Arrays;

public class BitBuilder {
    private static final byte[] bits = new byte[]{-128, 64, 32, 16, 8, 4, 2, 1};
    byte[] buf = new byte[1];
    int pos = 0;

    public BitBuilder writeBit(int n2) {
        if (this.pos / 8 >= this.buf.length) {
            byte[] byArray = new byte[this.buf.length + 4];
            System.arraycopy(this.buf, 0, byArray, 0, this.pos / 8);
            Arrays.clear(this.buf);
            this.buf = byArray;
        }
        if (n2 == 0) {
            int n3 = this.pos / 8;
            this.buf[n3] = (byte)(this.buf[n3] & ~bits[this.pos % 8]);
        } else {
            int n4 = this.pos / 8;
            this.buf[n4] = (byte)(this.buf[n4] | bits[this.pos % 8]);
        }
        ++this.pos;
        return this;
    }

    public BitBuilder writeBits(long l2, int n2) {
        for (int i2 = n2 - 1; i2 >= 0; --i2) {
            int n3 = (l2 & 1L << i2) > 0L ? 1 : 0;
            this.writeBit(n3);
        }
        return this;
    }

    public BitBuilder writeBits(long l2, int n2, int n3) {
        for (int i2 = n2 - 1; i2 >= n2 - n3; --i2) {
            int n4 = (l2 & 1L << i2) != 0L ? 1 : 0;
            this.writeBit(n4);
        }
        return this;
    }

    public int write(OutputStream outputStream) throws IOException {
        int n2 = (this.pos + this.pos % 8) / 8;
        outputStream.write(this.buf, 0, n2);
        outputStream.flush();
        return n2;
    }

    public int writeAndClear(OutputStream outputStream) throws IOException {
        int n2 = (this.pos + this.pos % 8) / 8;
        outputStream.write(this.buf, 0, n2);
        outputStream.flush();
        this.zero();
        return n2;
    }

    public void pad() {
        this.pos += this.pos % 8;
    }

    public void write7BitBytes(int n2) {
        boolean bl = false;
        for (int i2 = 4; i2 >= 0; --i2) {
            if (!bl && (n2 & 0xFE000000) != 0) {
                bl = true;
            }
            if (bl) {
                this.writeBit(i2).writeBits(n2, 32, 7);
            }
            n2 <<= 7;
        }
    }

    public void write7BitBytes(BigInteger bigInteger) {
        int n2 = (bigInteger.bitLength() + bigInteger.bitLength() % 8) / 8;
        BigInteger bigInteger2 = BigInteger.valueOf(254L).shiftLeft(n2 * 8);
        boolean bl = false;
        for (int i2 = n2; i2 >= 0; --i2) {
            if (!bl && bigInteger.and(bigInteger2).compareTo(BigInteger.ZERO) != 0) {
                bl = true;
            }
            if (bl) {
                BigInteger bigInteger3 = bigInteger.and(bigInteger2).shiftRight(8 * n2 - 8);
                this.writeBit(i2).writeBits(bigInteger3.intValue(), 8, 7);
            }
            bigInteger = bigInteger.shiftLeft(7);
        }
    }

    protected void finalize() throws Throwable {
        this.zero();
        super.finalize();
    }

    public void zero() {
        Arrays.clear(this.buf);
        this.pos = 0;
    }
}

