/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.crypto.modes.gcm;

import java.util.Vector;
import org.bouncycastle.crypto.modes.gcm.GCMExponentiator;
import org.bouncycastle.crypto.modes.gcm.GCMUtil;

public class Tables1kGCMExponentiator
implements GCMExponentiator {
    private Vector lookupPowX2;

    public void init(byte[] byArray) {
        long[] lArray = GCMUtil.asLongs(byArray);
        if (this.lookupPowX2 != null && 0L != GCMUtil.areEqual(lArray, (long[])this.lookupPowX2.elementAt(0))) {
            return;
        }
        this.lookupPowX2 = new Vector(8);
        this.lookupPowX2.addElement(lArray);
    }

    public void exponentiateX(long l2, byte[] byArray) {
        long[] lArray = GCMUtil.oneAsLongs();
        int n2 = 0;
        while (l2 > 0L) {
            if ((l2 & 1L) != 0L) {
                this.ensureAvailable(n2);
                GCMUtil.multiply(lArray, (long[])this.lookupPowX2.elementAt(n2));
            }
            ++n2;
            l2 >>>= 1;
        }
        GCMUtil.asBytes(lArray, byArray);
    }

    private void ensureAvailable(int n2) {
        int n3 = this.lookupPowX2.size() - 1;
        if (n3 < n2) {
            long[] lArray = (long[])this.lookupPowX2.elementAt(n3);
            do {
                long[] lArray2 = new long[2];
                GCMUtil.square(lArray, lArray2);
                this.lookupPowX2.addElement(lArray2);
                lArray = lArray2;
            } while (++n3 < n2);
        }
    }
}

