/*
 * Decompiled with CFR 0.152.
 */
package keySuite.token;

import iaik.pkcs.pkcs11.DefaultInitializeArgs;
import iaik.pkcs.pkcs11.Module;
import iaik.pkcs.pkcs11.Slot;
import iaik.pkcs.pkcs11.TokenException;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import keySuite.token.Token;

public class TokenEnvironment {
    private Slot ActiveSlot;
    private Module module;

    public ArrayList<String> FindAvailableDriver(String dll) {
        ArrayList<String> AvailableDll = new ArrayList<String>();
        File file = new File(dll);
        if (file.exists()) {
            AvailableDll.add(dll);
        }
        return AvailableDll;
    }

    public void LoadDll(String ProviderDll) throws IOException, TokenException {
        this.module = Module.getInstance(ProviderDll);
        this.module.initialize(new DefaultInitializeArgs());
    }

    public Token ConnectToken() {
        try {
            try {
                Thread.sleep(1000L);
            }
            catch (InterruptedException e2) {
                e2.printStackTrace();
            }
            Slot[] slotsWithToken = this.module.getSlotList(true);
            int slotIndex = slotsWithToken.length;
            if (slotIndex >= 1) {
                this.ActiveSlot = slotsWithToken[0];
                return new Token(this.ActiveSlot);
            }
            return null;
        }
        catch (TokenException tokenException) {
            return null;
        }
    }

    public Token ConnectTokenWithActiveSlot() {
        return new Token(this.ActiveSlot);
    }

    public boolean TokenRemoveListener() {
        try {
            Slot slot = this.module.waitForSlotEvent(true, null);
            return this.ActiveSlot.equals(slot);
        }
        catch (TokenException e2) {
            return false;
        }
    }

    public boolean TokenInsertListener() {
        try {
            this.module.waitForSlotEvent(true, null);
            return true;
        }
        catch (TokenException e2) {
            return false;
        }
    }

    public void ClearSlotActive() {
        this.ActiveSlot = null;
    }

    public boolean isSlotActive() {
        return this.ActiveSlot != null;
    }

    public void SetSlotActive(Slot sl) {
        this.ActiveSlot = sl;
    }

    public boolean isTokenOnSlot() {
        try {
            Slot[] slotsWithToken = this.module.getSlotList(true);
            if (slotsWithToken.length > 0) {
                this.SetSlotActive(slotsWithToken[0]);
                return true;
            }
        }
        catch (TokenException tokenException) {
            // empty catch block
        }
        return false;
    }

    public Slot[] getSlotsList() {
        Slot[] slotsWithToken = null;
        try {
            slotsWithToken = this.module.getSlotList(true);
        }
        catch (TokenException e2) {
            e2.printStackTrace();
        }
        return slotsWithToken;
    }

    public Slot getSlotWithTokenSerial(String tokenSerial) {
        Slot[] slotList = this.getSlotsList();
        Slot slot = null;
        int j2 = 0;
        while (j2 < slotList.length) {
            try {
                if (slotList[j2].getToken().getTokenInfo().getSerialNumber().trim().equals(tokenSerial)) {
                    slot = slotList[j2];
                    break;
                }
            }
            catch (TokenException e2) {
                e2.printStackTrace();
            }
            ++j2;
        }
        return slot;
    }

    public void DestroyModule() {
        try {
            this.module.finalize(null);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }
}

