/*
 * Decompiled with CFR 0.152.
 */
package keySuite.token;

import iaik.pkcs.pkcs11.Mechanism;
import iaik.pkcs.pkcs11.Session;
import iaik.pkcs.pkcs11.Slot;
import iaik.pkcs.pkcs11.TokenException;
import iaik.pkcs.pkcs11.objects.KeyPair;
import iaik.pkcs.pkcs11.objects.RSAPrivateKey;
import iaik.pkcs.pkcs11.objects.RSAPublicKey;
import iaik.pkcs.pkcs11.objects.X509PublicKeyCertificate;
import java.io.ByteArrayInputStream;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.cert.CertificateEncodingException;
import java.security.cert.CertificateException;
import java.security.cert.CertificateFactory;
import java.security.cert.X509Certificate;
import java.util.ArrayList;

public class Token
extends iaik.pkcs.pkcs11.Token {
    private Session TokenSession;

    public Token(Slot SlotWithToken) {
        super(SlotWithToken);
        try {
            this.TokenSession = super.openSession(true, true, null, null);
        }
        catch (TokenException e2) {
            e2.printStackTrace();
        }
    }

    public String Authentication(String InputPin) {
        try {
            this.TokenSession.login(true, InputPin.toCharArray());
        }
        catch (TokenException e2) {
            return e2.getMessage();
        }
        return null;
    }

    public KeyPair GenerateKey(String KeyAlias, Integer KeySizeBit, boolean KeepInToken) throws TokenException, NoSuchAlgorithmException {
        RSAPublicKey PublicKeyTemplate = new RSAPublicKey();
        PublicKeyTemplate.getModulusBits().setLongValue(new Long(KeySizeBit.intValue()));
        MessageDigest md = MessageDigest.getInstance("SHA1");
        md.update(KeyAlias.getBytes());
        byte[] digestByte = md.digest();
        byte[] byArray = new byte[3];
        byArray[0] = 1;
        byArray[2] = 1;
        byte[] publicExponentBytes = byArray;
        PublicKeyTemplate.getPublicExponent().setByteArrayValue(publicExponentBytes);
        PublicKeyTemplate.getVerify().setBooleanValue(Boolean.TRUE);
        PublicKeyTemplate.getEncrypt().setBooleanValue(Boolean.TRUE);
        PublicKeyTemplate.getToken().setBooleanValue(KeepInToken);
        PublicKeyTemplate.getId().setByteArrayValue(digestByte);
        PublicKeyTemplate.getLabel().setCharArrayValue(KeyAlias.toCharArray());
        RSAPrivateKey PrivateKeyTemplate = new RSAPrivateKey();
        PrivateKeyTemplate.getPrivate().setBooleanValue(Boolean.TRUE);
        PrivateKeyTemplate.getSign().setBooleanValue(Boolean.TRUE);
        PrivateKeyTemplate.getDecrypt().setBooleanValue(Boolean.TRUE);
        PrivateKeyTemplate.getToken().setBooleanValue(KeepInToken);
        PrivateKeyTemplate.getId().setByteArrayValue(digestByte);
        PrivateKeyTemplate.getLabel().setCharArrayValue(KeyAlias.toCharArray());
        return this.TokenSession.generateKeyPair(Mechanism.RSA_PKCS_KEY_PAIR_GEN, PublicKeyTemplate, PrivateKeyTemplate);
    }

    public byte[] SignSignature(byte[] DataBytes, RSAPrivateKey SignatureKey) throws TokenException {
        byte[] SignatureByte = null;
        Mechanism SignatureMechanism = Mechanism.SHA512_RSA_PKCS;
        this.TokenSession.signInit(SignatureMechanism, SignatureKey);
        SignatureByte = this.TokenSession.sign(DataBytes);
        return SignatureByte;
    }

    public X509PublicKeyCertificate ImportCertificate(String KeyAlias, boolean KeepInToken, X509Certificate Cert) throws TokenException, CertificateEncodingException, NoSuchAlgorithmException {
        X509PublicKeyCertificate CertTemplate2 = new X509PublicKeyCertificate();
        MessageDigest md = MessageDigest.getInstance("SHA1");
        md.update(KeyAlias.getBytes());
        byte[] digestByte = md.digest();
        CertTemplate2.getPrivate().setBooleanValue(false);
        CertTemplate2.getToken().setBooleanValue(KeepInToken);
        CertTemplate2.getLabel().setCharArrayValue(KeyAlias.toCharArray());
        CertTemplate2.getId().setByteArrayValue(digestByte);
        CertTemplate2.getValue().setByteArrayValue(Cert.getEncoded());
        CertTemplate2.getSubject().setByteArrayValue(Cert.getSubjectDN().getName().getBytes());
        CertTemplate2.getSerialNumber().setByteArrayValue(Cert.getSerialNumber().toByteArray());
        CertTemplate2.getIssuer().setByteArrayValue(Cert.getIssuerDN().getName().getBytes());
        return (X509PublicKeyCertificate)this.CreateObject(CertTemplate2);
    }

    public iaik.pkcs.pkcs11.objects.Object CreateObject(iaik.pkcs.pkcs11.objects.Object ObjectTemplate) throws TokenException {
        return this.TokenSession.createObject(ObjectTemplate);
    }

    public ArrayList<X509Certificate> getCertificate() {
        ArrayList<X509Certificate> cert = new ArrayList<X509Certificate>();
        X509PublicKeyCertificate tempCert = new X509PublicKeyCertificate();
        try {
            this.TokenSession.findObjectsInit(tempCert);
            iaik.pkcs.pkcs11.objects.Object[] foundCerts = this.TokenSession.findObjects(10);
            if (foundCerts.length > 0) {
                int i2 = 0;
                while (i2 < foundCerts.length) {
                    X509PublicKeyCertificate foundCert = (X509PublicKeyCertificate)foundCerts[i2];
                    CertificateFactory certFac = CertificateFactory.getInstance("X.509");
                    byte[] encCert = foundCert.getValue().getByteArrayValue();
                    cert.add((X509Certificate)certFac.generateCertificate(new ByteArrayInputStream(encCert)));
                    ++i2;
                }
            }
            this.TokenSession.findObjectsFinal();
        }
        catch (TokenException tokenException) {
        }
        catch (CertificateException certificateException) {
            // empty catch block
        }
        return cert;
    }

    public iaik.pkcs.pkcs11.objects.Object[] FindObject(iaik.pkcs.pkcs11.objects.Object ObjectTemplate) throws TokenException {
        Integer MAX_Find_Object = 80;
        this.TokenSession.findObjectsInit(ObjectTemplate);
        iaik.pkcs.pkcs11.objects.Object[] matchingObjects = this.TokenSession.findObjects(MAX_Find_Object);
        this.TokenSession.findObjectsFinal();
        if (matchingObjects.length > 0) {
            return matchingObjects;
        }
        return null;
    }

    public String getManufacture() {
        try {
            return super.getTokenInfo().getManufacturerID();
        }
        catch (TokenException tokenException) {
            return null;
        }
    }

    public String getSerialNumber() {
        try {
            return super.getTokenInfo().getSerialNumber();
        }
        catch (TokenException tokenException) {
            return null;
        }
    }

    public void LogoutSession() {
        try {
            this.TokenSession.logout();
        }
        catch (TokenException tokenException) {
            // empty catch block
        }
    }

    public static String getNewPin(String tokkenNo) {
        Object NewPin = "";
        int i2 = 0;
        while (i2 < tokkenNo.length()) {
            Integer temp = Character.getNumericValue(tokkenNo.charAt(i2));
            temp = temp == 9 ? Integer.valueOf(0) : Integer.valueOf(temp + 1);
            NewPin = (String)NewPin + temp.toString();
            ++i2;
        }
        return NewPin;
    }

    public boolean IsUserPinLock() {
        try {
            boolean test = super.getTokenInfo().isUserPinLocked();
            return test;
        }
        catch (TokenException e2) {
            return true;
        }
    }
}

