/*
 * Decompiled with CFR 0.152.
 */
package keySuite.panel;

import java.awt.Color;
import java.awt.Font;
import java.io.File;
import java.io.IOException;
import java.security.KeyPair;
import java.security.NoSuchAlgorithmException;
import javax.security.auth.x500.X500Principal;
import javax.swing.GroupLayout;
import javax.swing.ImageIcon;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.LayoutStyle;
import keySuite.Main;
import keySuite.dateAndTime.DateAndTime;
import keySuite.file.BrowseFile;
import keySuite.keyPair.Generator;
import keySuite.keyPair.SaveToFile;
import keySuite.pkcs10.CSRGenerator;
import keySuite.properties.PropertiesManagement;
import org.bouncycastle.asn1.x500.X500Name;
import org.bouncycastle.operator.OperatorCreationException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class P12GenKeyPanel
extends JPanel
implements Runnable {
    static final Logger log = LoggerFactory.getLogger(Thread.currentThread().getStackTrace()[1].getClassName());
    Thread genKeyThread;
    private JLabel iconLabel;
    private JLabel textLabel;

    public P12GenKeyPanel() {
        this.initComponents();
        this.genKeyThread = new Thread(this);
        this.genKeyThread.start();
    }

    private void initComponents() {
        this.textLabel = new JLabel();
        this.iconLabel = new JLabel();
        this.textLabel.setFont(new Font("Tahoma", 0, 14));
        this.textLabel.setForeground(new Color(102, 102, 102));
        this.textLabel.setHorizontalAlignment(0);
        this.iconLabel.setHorizontalAlignment(0);
        GroupLayout layout = new GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.iconLabel, -1, 380, Short.MAX_VALUE).addComponent(this.textLabel, -1, -1, Short.MAX_VALUE)).addContainerGap()));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addComponent(this.iconLabel, -2, 150, -2).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.textLabel, -2, 25, -2).addContainerGap(33, Short.MAX_VALUE)));
    }

    /*
     * Loose catch block
     */
    @Override
    public void run() {
        block12: {
            this.iconLabel.setIcon(new ImageIcon("./res/images/loading.gif"));
            this.textLabel.setText("\u0e01\u0e33\u0e25\u0e31\u0e07\u0e2a\u0e23\u0e49\u0e32\u0e07\u0e44\u0e1f\u0e25\u0e4c\u0e01\u0e38\u0e0d\u0e41\u0e08\u0e2a\u0e48\u0e27\u0e19\u0e15\u0e31\u0e27\u0e41\u0e25\u0e30\u0e44\u0e1f\u0e25\u0e4c CSR");
            try {
                try {
                    PropertiesManagement prop = new PropertiesManagement();
                    int keySize = Integer.parseInt(prop.getProperties("keySize"));
                    Generator generator = new Generator();
                    KeyPair keyPair = generator.generateKeyPair(keySize);
                    this.textLabel.setText("\u0e1a\u0e31\u0e19\u0e17\u0e36\u0e01\u0e44\u0e1f\u0e25\u0e4c\u0e01\u0e38\u0e0d\u0e41\u0e08\u0e2a\u0e48\u0e27\u0e19\u0e15\u0e31\u0e27\u0e41\u0e25\u0e30\u0e44\u0e1f\u0e25\u0e4c CSR");
                    this.iconLabel.setIcon(new ImageIcon("./res/images/loading.png"));
                    boolean isDone = false;
                    do {
                        String filePath;
                        if ((filePath = new BrowseFile().getDirectory("\u0e23\u0e30\u0e1a\u0e38\u0e17\u0e35\u0e48\u0e2d\u0e22\u0e39\u0e48\u0e2a\u0e33\u0e2b\u0e23\u0e31\u0e1a\u0e1a\u0e31\u0e19\u0e17\u0e36\u0e01\u0e44\u0e1f\u0e25\u0e4c\u0e01\u0e38\u0e0d\u0e41\u0e08\u0e2a\u0e48\u0e27\u0e19\u0e15\u0e31\u0e27\u0e41\u0e25\u0e30\u0e44\u0e1f\u0e25\u0e4c CSR", new File(System.getProperty("user.dir")), "Choose")) != null) {
                            SaveToFile saveToFile = new SaveToFile();
                            String keyFileName = String.valueOf(Main.applicationID) + "_" + DateAndTime.getCurrentTime("yyMMddHHmmss") + ".key";
                            saveToFile.savePrivateKeyToFile(keyPair.getPrivate(), filePath, keyFileName);
                            CSRGenerator csrGenerator = new CSRGenerator();
                            String CN = prop.getProperties("csr.cn");
                            String O = prop.getProperties("csr.o");
                            String C = prop.getProperties("csr.c");
                            X500Principal principal = new X500Principal("CN=" + CN + ",O=" + O + ",C=" + C);
                            X500Name x500Name = new X500Name(principal.getName());
                            byte[] certReq = csrGenerator.genCSRFile(keyPair, x500Name);
                            String csrFileName = String.valueOf(Main.applicationID) + "_" + DateAndTime.getCurrentTime("yyMMddHHmmss") + ".csr";
                            CSRGenerator.writeCSRFile(certReq, String.valueOf(filePath) + File.separator + csrFileName);
                            this.textLabel.setText("\u0e2a\u0e23\u0e49\u0e32\u0e07\u0e44\u0e1f\u0e25\u0e4c\u0e01\u0e38\u0e0d\u0e41\u0e08\u0e2a\u0e48\u0e27\u0e19\u0e15\u0e31\u0e27\u0e41\u0e25\u0e30\u0e44\u0e1f\u0e25\u0e4c CSR \u0e40\u0e2a\u0e23\u0e47\u0e08\u0e2a\u0e21\u0e1a\u0e39\u0e23\u0e13\u0e4c");
                            log.info("\u0e2a\u0e23\u0e49\u0e32\u0e07\u0e44\u0e1f\u0e25\u0e4c\u0e01\u0e38\u0e0d\u0e41\u0e08\u0e2a\u0e48\u0e27\u0e19\u0e15\u0e31\u0e27\u0e41\u0e25\u0e30\u0e44\u0e1f\u0e25\u0e4c CSR \u0e40\u0e2a\u0e23\u0e47\u0e08\u0e2a\u0e21\u0e1a\u0e39\u0e23\u0e13\u0e4c (\u0e44\u0e1f\u0e25\u0e4c\u0e16\u0e39\u0e01\u0e1a\u0e31\u0e19\u0e17\u0e36\u0e01\u0e17\u0e35\u0e48 : " + filePath + ")");
                            JOptionPane.showMessageDialog(null, "<html>\u0e1a\u0e31\u0e19\u0e17\u0e36\u0e01\u0e44\u0e1f\u0e25\u0e4c\u0e01\u0e38\u0e0d\u0e41\u0e08\u0e2a\u0e48\u0e27\u0e19\u0e15\u0e31\u0e27\u0e41\u0e25\u0e30\u0e44\u0e1f\u0e25\u0e4c CSR \u0e1a\u0e19\u0e40\u0e04\u0e23\u0e37\u0e48\u0e2d\u0e07\u0e04\u0e2d\u0e21\u0e1e\u0e34\u0e27\u0e40\u0e15\u0e2d\u0e23\u0e4c\u0e02\u0e2d\u0e07\u0e17\u0e48\u0e32\u0e19\u0e40\u0e2a\u0e23\u0e47\u0e08\u0e2a\u0e21\u0e1a\u0e39\u0e23\u0e13\u0e4c\u0e41\u0e25\u0e49\u0e27(\u0e08\u0e1a\u0e02\u0e31\u0e49\u0e19\u0e15\u0e2d\u0e19\u0e17\u0e35\u0e48 1)<br>\u0e42\u0e1b\u0e23\u0e14\u0e40\u0e01\u0e47\u0e1a\u0e23\u0e31\u0e01\u0e29\u0e32\u0e44\u0e1f\u0e25\u0e4c CSR \u0e40\u0e1e\u0e37\u0e48\u0e2d\u0e19\u0e33\u0e44\u0e1b\u0e43\u0e0a\u0e49\u0e43\u0e19\u0e02\u0e31\u0e49\u0e19\u0e15\u0e2d\u0e19\u0e23\u0e31\u0e1a\u0e44\u0e1f\u0e25\u0e4c\u0e43\u0e1a\u0e23\u0e31\u0e1a\u0e23\u0e2d\u0e07\u0e2d\u0e34\u0e40\u0e25\u0e47\u0e01\u0e17\u0e23\u0e2d\u0e19\u0e34\u0e01\u0e2a\u0e4c(\u0e02\u0e31\u0e49\u0e19\u0e15\u0e2d\u0e19\u0e17\u0e35\u0e48 2)</html>", "\u0e1c\u0e25\u0e25\u0e31\u0e1e\u0e18\u0e4c", 1);
                            isDone = true;
                            continue;
                        }
                        if (JOptionPane.showConfirmDialog(null, "\u0e17\u0e48\u0e32\u0e19\u0e08\u0e33\u0e40\u0e1b\u0e47\u0e19\u0e15\u0e49\u0e2d\u0e07\u0e43\u0e0a\u0e49\u0e44\u0e1f\u0e25\u0e4c\u0e01\u0e38\u0e0d\u0e41\u0e08\u0e2a\u0e48\u0e27\u0e19\u0e15\u0e31\u0e27\u0e41\u0e25\u0e30\u0e44\u0e1f\u0e25\u0e4c CSR \u0e43\u0e19\u0e02\u0e31\u0e49\u0e19\u0e15\u0e2d\u0e19\u0e15\u0e48\u0e2d\u0e44\u0e1b \u0e17\u0e48\u0e32\u0e19\u0e22\u0e37\u0e19\u0e22\u0e31\u0e19\u0e17\u0e35\u0e48\u0e08\u0e30\u0e44\u0e21\u0e48\u0e1a\u0e31\u0e19\u0e17\u0e36\u0e01\u0e44\u0e1f\u0e25\u0e4c\u0e01\u0e38\u0e0d\u0e41\u0e08\u0e2a\u0e48\u0e27\u0e19\u0e15\u0e31\u0e27\u0e41\u0e25\u0e30\u0e44\u0e1f\u0e25\u0e4c CSR \u0e19\u0e35\u0e49\u0e43\u0e0a\u0e48\u0e2b\u0e23\u0e37\u0e2d\u0e44\u0e21\u0e48 ?", "\u0e22\u0e37\u0e19\u0e22\u0e31\u0e19", 0) == 1) {
                            isDone = false;
                            continue;
                        }
                        JOptionPane.showMessageDialog(null, "\u0e44\u0e1f\u0e25\u0e4c\u0e01\u0e38\u0e0d\u0e41\u0e08\u0e2a\u0e48\u0e27\u0e19\u0e15\u0e31\u0e27\u0e41\u0e25\u0e30\u0e44\u0e1f\u0e25\u0e4c CSR \u0e44\u0e21\u0e48\u0e44\u0e14\u0e49\u0e16\u0e39\u0e01\u0e08\u0e31\u0e14\u0e40\u0e01\u0e47\u0e1a \u0e01\u0e23\u0e38\u0e13\u0e32\u0e2a\u0e23\u0e49\u0e32\u0e07\u0e01\u0e38\u0e0d\u0e41\u0e08\u0e2a\u0e48\u0e27\u0e19\u0e15\u0e31\u0e27\u0e41\u0e25\u0e30\u0e44\u0e1f\u0e25\u0e4c CSR \u0e43\u0e2b\u0e21\u0e48\u0e2d\u0e35\u0e01\u0e04\u0e23\u0e31\u0e49\u0e07", "\u0e02\u0e49\u0e2d\u0e1c\u0e34\u0e14\u0e1e\u0e25\u0e32\u0e14", 0);
                        isDone = true;
                    } while (!isDone);
                }
                catch (NoSuchAlgorithmException e2) {
                    e2.printStackTrace();
                    log.error(e2.getMessage(), e2);
                    JOptionPane.showMessageDialog(null, e2.getMessage(), "\u0e02\u0e49\u0e2d\u0e1c\u0e34\u0e14\u0e1e\u0e25\u0e32\u0e14", 0);
                    this.closePanel();
                }
                catch (IOException e3) {
                    e3.printStackTrace();
                    log.error(e3.getMessage(), e3);
                    JOptionPane.showMessageDialog(null, e3.getMessage(), "\u0e02\u0e49\u0e2d\u0e1c\u0e34\u0e14\u0e1e\u0e25\u0e32\u0e14", 0);
                    this.closePanel();
                }
                catch (OperatorCreationException e4) {
                    e4.printStackTrace();
                    log.error(e4.getMessage(), e4);
                    JOptionPane.showMessageDialog(null, e4.getMessage(), "\u0e02\u0e49\u0e2d\u0e1c\u0e34\u0e14\u0e1e\u0e25\u0e32\u0e14", 0);
                    this.closePanel();
                    break block12;
                    {
                        catch (Throwable throwable) {
                            throw throwable;
                        }
                    }
                }
            }
            finally {
                this.closePanel();
            }
        }
    }

    public void closePanel() {
        JOptionPane.getRootFrame().dispose();
        this.genKeyThread.interrupt();
    }
}

