/*
 * Decompiled with CFR 0.152.
 */
package iaik.pkcs.pkcs12;

import iaik.asn1.ASN;
import iaik.asn1.ASN1Object;
import iaik.asn1.CodingException;
import iaik.asn1.DerCoder;
import iaik.asn1.INTEGER;
import iaik.asn1.OCTET_STRING;
import iaik.asn1.ObjectID;
import iaik.asn1.SEQUENCE;
import iaik.asn1.structures.AlgorithmID;
import iaik.pkcs.PKCSException;
import iaik.pkcs.PKCSParsingException;
import iaik.pkcs.pkcs12.AuthenticatedSafe;
import iaik.pkcs.pkcs12.CertificateBag;
import iaik.pkcs.pkcs12.KeyBag;
import iaik.pkcs.pkcs12.PKCS8ShroudedKeyBag;
import iaik.pkcs.pkcs12.SafeBag;
import iaik.pkcs.pkcs7.Content;
import iaik.pkcs.pkcs7.ContentInfo;
import iaik.pkcs.pkcs7.Data;
import iaik.pkcs.pkcs7.DataStream;
import iaik.pkcs.pkcs7.DigestInfo;
import iaik.security.cipher.PBEKeyBMP;
import iaik.security.pbe.PBEGenParameterSpec;
import iaik.security.spec.PBEKeyAndParameterSpec;
import iaik.utils.CryptoUtils;
import iaik.utils.InternalErrorException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.math.BigInteger;
import java.security.AlgorithmParameterGenerator;
import java.security.AlgorithmParameters;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import java.security.spec.AlgorithmParameterSpec;
import java.security.spec.InvalidParameterSpecException;
import java.util.Vector;
import javax.crypto.KeyGenerator;
import javax.crypto.Mac;
import javax.crypto.SecretKey;
import javax.crypto.spec.PBEParameterSpec;

public class PKCS12 {
    static /* synthetic */ Class f;
    boolean d;
    PKCS8ShroudedKeyBag b;
    byte[] g;
    ASN1Object c;
    SEQUENCE e;
    private int a = 3;
    protected int mode;
    protected AuthenticatedSafe[] authenticated_safes;
    public static final int PASSWORD_INTEGRITY_MODE = 2;
    public static final int PUBLIC_KEY_INTEGRITY_MODE = 1;
    private static final boolean h = false;
    private static final boolean i = false;

    static Class a(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    public void writeTo(OutputStream outputStream) throws IOException {
        DerCoder.encodeTo(this.c, outputStream);
    }

    public boolean verify(char[] cArray) throws PKCSException {
        try {
            DigestInfo digestInfo = new DigestInfo(this.e.getComponentAt(0));
            byte[] byArray = (byte[])this.e.getComponentAt(1).getValue();
            int n2 = 1;
            if (this.e.countComponents() > 2) {
                n2 = ((BigInteger)this.e.getComponentAt(2).getValue()).intValue();
            }
            PBEKeyAndParameterSpec pBEKeyAndParameterSpec = new PBEKeyAndParameterSpec(PBEKeyBMP.getEncoded(cArray), byArray, n2, 20);
            KeyGenerator keyGenerator = KeyGenerator.getInstance("PKCS#12-MAC");
            keyGenerator.init(pBEKeyAndParameterSpec);
            SecretKey secretKey = keyGenerator.generateKey();
            Mac mac = Mac.getInstance("HMAC/SHA");
            mac.init(secretKey);
            byte[] byArray2 = mac.doFinal(this.g);
            return CryptoUtils.equalsBlock(byArray2, digestInfo.getDigest());
        }
        catch (InvalidAlgorithmParameterException invalidAlgorithmParameterException) {
            throw new PKCSException(invalidAlgorithmParameterException.toString());
        }
        catch (CodingException codingException) {
            throw new PKCSException(codingException.toString());
        }
        catch (InvalidKeyException invalidKeyException) {
            throw new PKCSException(invalidKeyException.toString());
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            throw new PKCSException(noSuchAlgorithmException.toString());
        }
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("PKCS#12 object:\n");
        stringBuffer.append("Version: " + this.a + "\n");
        if (this.authenticated_safes == null) {
            stringBuffer.append("No content.\n");
        } else {
            int n2 = 0;
            while (n2 < this.authenticated_safes.length) {
                stringBuffer.append("AuthenticatedSafe: " + n2 + "\n");
                stringBuffer.append(this.authenticated_safes[n2].toString());
                stringBuffer.append("\n");
                ++n2;
            }
        }
        return stringBuffer.toString();
    }

    public ASN1Object toASN1Object() throws PKCSException {
        return this.c;
    }

    public KeyBag[] getKeyBags() {
        SafeBag[] safeBagArray;
        Vector<SafeBag> vector = new Vector<SafeBag>(2);
        int n2 = 0;
        while (n2 < this.authenticated_safes.length) {
            safeBagArray = this.authenticated_safes[n2].getSafeBags();
            int n3 = 0;
            while (n3 < safeBagArray.length) {
                if (safeBagArray[n3] instanceof KeyBag) {
                    vector.addElement(safeBagArray[n3]);
                }
                ++n3;
            }
            ++n2;
        }
        safeBagArray = new KeyBag[vector.size()];
        vector.copyInto(safeBagArray);
        return safeBagArray;
    }

    public KeyBag getKeyBag() {
        int n2 = 0;
        while (n2 < this.authenticated_safes.length) {
            SafeBag[] safeBagArray = this.authenticated_safes[n2].getSafeBags();
            int n3 = 0;
            while (n3 < safeBagArray.length) {
                if (safeBagArray[n3] instanceof KeyBag) {
                    return (KeyBag)safeBagArray[n3];
                }
                ++n3;
            }
            ++n2;
        }
        return null;
    }

    public CertificateBag[] getCertificateBags() {
        SafeBag[] safeBagArray;
        Vector<SafeBag> vector = new Vector<SafeBag>();
        int n2 = 0;
        while (n2 < this.authenticated_safes.length) {
            safeBagArray = this.authenticated_safes[n2].getSafeBags();
            int n3 = 0;
            while (n3 < safeBagArray.length) {
                if (safeBagArray[n3] instanceof CertificateBag) {
                    vector.addElement(safeBagArray[n3]);
                }
                ++n3;
            }
            ++n2;
        }
        safeBagArray = new CertificateBag[vector.size()];
        vector.copyInto(safeBagArray);
        return safeBagArray;
    }

    public AuthenticatedSafe[] getAuthenticatedSafes() {
        return this.authenticated_safes;
    }

    public void encrypt(char[] cArray, AlgorithmID algorithmID, AlgorithmID algorithmID2) throws PKCSException {
        Object object;
        Object object2;
        AlgorithmID algorithmID3 = null;
        AlgorithmID algorithmID4 = null;
        algorithmID3 = algorithmID == null ? (AlgorithmID)AlgorithmID.pbeWithSHAAnd40BitRC2_CBC.clone() : algorithmID;
        algorithmID4 = algorithmID2 == null ? (AlgorithmID)AlgorithmID.pbeWithSHAAnd3_KeyTripleDES_CBC.clone() : algorithmID2;
        PBEParameterSpec pBEParameterSpec = null;
        try {
            int n2 = this.d ? 2000 : 1;
            object2 = new PBEGenParameterSpec(8, n2);
            object = AlgorithmParameterGenerator.getInstance("PBE");
            ((AlgorithmParameterGenerator)object).init((AlgorithmParameterSpec)object2);
            AlgorithmParameters algorithmParameters = ((AlgorithmParameterGenerator)object).generateParameters();
            pBEParameterSpec = (PBEParameterSpec)algorithmParameters.getParameterSpec(f != null ? f : (f = PKCS12.a("javax.crypto.spec.PBEParameterSpec")));
            algorithmID3.setAlgorithmParameters(algorithmParameters);
            this.b.encrypt(cArray, algorithmID4, n2);
            this.authenticated_safes[0] = new AuthenticatedSafe(1, new SafeBag[]{this.b});
            int n3 = 0;
            while (n3 < this.authenticated_safes.length) {
                this.authenticated_safes[n3].encrypt(cArray, algorithmID3);
                ++n3;
            }
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            throw new InternalErrorException(noSuchAlgorithmException.toString());
        }
        catch (InvalidParameterSpecException invalidParameterSpecException) {
            throw new InternalErrorException(invalidParameterSpecException);
        }
        catch (InvalidAlgorithmParameterException invalidAlgorithmParameterException) {
            throw new InternalErrorException(invalidAlgorithmParameterException);
        }
        if (this.mode == 2) {
            try {
                ASN1Object aSN1Object = ASN.createSequenceOf(this.authenticated_safes);
                aSN1Object.setIndefiniteLength(true);
                this.g = DerCoder.encode(aSN1Object);
                object2 = new Data(this.g);
                ((DataStream)object2).setBlockSize(1024);
                object = new ContentInfo((Content)object2);
                this.a(cArray);
                this.c = new SEQUENCE();
                this.c.addComponent(new INTEGER(this.a));
                this.c.addComponent(((ContentInfo)object).toASN1Object());
                if (this.e != null) {
                    this.c.addComponent(this.e);
                }
                this.c.setIndefiniteLength(true);
                return;
            }
            catch (CodingException codingException) {
                throw new RuntimeException(codingException.toString());
            }
        }
    }

    public void encrypt(char[] cArray) throws PKCSException {
        this.encrypt(cArray, null, null);
    }

    public void decrypt(char[] cArray) throws PKCSException {
        try {
            int n2 = 0;
            while (n2 < this.authenticated_safes.length) {
                this.authenticated_safes[n2].decrypt(cArray);
                ++n2;
            }
            return;
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            throw new PKCSException(noSuchAlgorithmException.toString());
        }
    }

    protected void decode() throws PKCSParsingException {
        try {
            if (this.c.getComponentAt(0).isA(ASN.CON_SPEC)) {
                throw new PKCSParsingException("Key format of Netscape 4.03 and earlier not supportet!");
            }
            this.a = ((BigInteger)this.c.getComponentAt(0).getValue()).intValue();
            ContentInfo contentInfo = new ContentInfo(this.c.getComponentAt(1));
            if (this.c.countComponents() == 3) {
                this.e = (SEQUENCE)this.c.getComponentAt(2);
            }
            if (contentInfo.getContentType().equals(ObjectID.pkcs7_data)) {
                this.mode = 2;
                this.g = ((Data)contentInfo.getContent()).getData();
                ASN1Object aSN1Object = DerCoder.decode(this.g);
                this.authenticated_safes = new AuthenticatedSafe[aSN1Object.countComponents()];
                int n2 = 0;
                while (n2 < aSN1Object.countComponents()) {
                    this.authenticated_safes[n2] = new AuthenticatedSafe(aSN1Object.getComponentAt(n2));
                    ++n2;
                }
                return;
            }
            if (contentInfo.getContentType().equals(ObjectID.pkcs7_signedData)) {
                this.mode = 1;
                return;
            }
            throw new PKCSParsingException("PKCS#12: Unknown mode!");
        }
        catch (PKCSException pKCSException) {
            throw new PKCSParsingException(pKCSException.toString());
        }
        catch (CodingException codingException) {
            throw new PKCSParsingException(codingException.toString());
        }
        catch (ClassCastException classCastException) {
            throw new PKCSParsingException(classCastException.toString());
        }
    }

    private void a(char[] cArray) throws PKCSException {
        try {
            int n2 = this.d ? 2000 : 1;
            PBEGenParameterSpec pBEGenParameterSpec = new PBEGenParameterSpec(8, n2);
            AlgorithmParameterGenerator algorithmParameterGenerator = AlgorithmParameterGenerator.getInstance("PBE");
            algorithmParameterGenerator.init(pBEGenParameterSpec);
            AlgorithmParameters algorithmParameters = algorithmParameterGenerator.generateParameters();
            PBEParameterSpec pBEParameterSpec = (PBEParameterSpec)algorithmParameters.getParameterSpec(f != null ? f : (f = PKCS12.a("javax.crypto.spec.PBEParameterSpec")));
            PBEKeyAndParameterSpec pBEKeyAndParameterSpec = new PBEKeyAndParameterSpec(PBEKeyBMP.getEncoded(cArray), pBEParameterSpec.getSalt(), pBEParameterSpec.getIterationCount(), 20);
            KeyGenerator keyGenerator = KeyGenerator.getInstance("PKCS#12-MAC");
            keyGenerator.init(pBEKeyAndParameterSpec);
            SecretKey secretKey = keyGenerator.generateKey();
            Mac mac = Mac.getInstance("HMAC/SHA");
            mac.init(secretKey);
            byte[] byArray = mac.doFinal(this.g);
            DigestInfo digestInfo = new DigestInfo(AlgorithmID.sha, byArray);
            this.e = new SEQUENCE();
            this.e.addComponent(digestInfo.toASN1Object());
            this.e.addComponent(new OCTET_STRING(pBEParameterSpec.getSalt()));
            if (pBEParameterSpec.getIterationCount() != 1) {
                this.e.addComponent(new INTEGER(pBEParameterSpec.getIterationCount()));
                return;
            }
        }
        catch (InvalidAlgorithmParameterException invalidAlgorithmParameterException) {
            throw new PKCSException(invalidAlgorithmParameterException.toString());
        }
        catch (InvalidParameterSpecException invalidParameterSpecException) {
            throw new PKCSException(invalidParameterSpecException.toString());
        }
        catch (InvalidKeyException invalidKeyException) {
            throw new PKCSException(invalidKeyException.toString());
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            throw new PKCSException(noSuchAlgorithmException.toString());
        }
    }

    public PKCS12(InputStream inputStream) throws PKCSParsingException, IOException {
        try {
            this.c = DerCoder.decode(inputStream);
        }
        catch (CodingException codingException) {
            throw new PKCSParsingException(codingException.getMessage());
        }
        this.decode();
    }

    public PKCS12(KeyBag keyBag, CertificateBag[] certificateBagArray, boolean bl) throws PKCSException {
        this(keyBag, certificateBagArray);
        this.d = bl;
    }

    public PKCS12(KeyBag keyBag, CertificateBag[] certificateBagArray) throws PKCSException {
        this.authenticated_safes = new AuthenticatedSafe[2];
        this.b = new PKCS8ShroudedKeyBag(keyBag);
        this.authenticated_safes[1] = new AuthenticatedSafe(2, certificateBagArray);
        this.mode = 2;
    }

    public PKCS12(ASN1Object aSN1Object) throws PKCSParsingException {
        this.c = aSN1Object;
        this.decode();
    }
}

