/*
 * Decompiled with CFR 0.152.
 */
package iaik.asn1.structures;

import iaik.asn1.ASN;
import iaik.asn1.ASN1Object;
import iaik.asn1.CodingException;
import iaik.asn1.IA5String;
import iaik.asn1.INTEGER;
import iaik.asn1.ObjectID;
import iaik.asn1.SEQUENCE;
import iaik.asn1.VisibleString;
import iaik.utils.InternalErrorException;
import java.math.BigInteger;

public class PolicyQualifierInfo {
    private ASN1Object f;
    ASN1Object d;
    int[] c;
    ASN1Object b;
    String e;
    ObjectID a;

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("policyQualifierId: " + this.a.getName() + "\n");
        if (this.a.equals(ObjectID.id_pkix_cps)) {
            stringBuffer.append("CPS URI: " + this.e + "\n");
        } else if (this.a.equals(ObjectID.id_pkix_unotice)) {
            if (this.b != null) {
                stringBuffer.append("organization: " + this.b.getValue() + "\n");
            }
            if (this.c != null) {
                int n2 = 0;
                while (n2 < this.c.length) {
                    stringBuffer.append("noticeNumber[" + n2 + "]: " + this.c[n2] + "\n");
                    ++n2;
                }
            }
            if (this.d != null) {
                stringBuffer.append("displayText: " + this.d.getValue() + "\n");
            }
        } else {
            stringBuffer.append("Unknown qualifier " + this.a + "\n");
        }
        stringBuffer.setLength(stringBuffer.length() - 1);
        return stringBuffer.toString();
    }

    public ASN1Object toASN1Object() {
        return this.f;
    }

    public ASN1Object getQualifierValue() {
        try {
            return this.f.getComponentAt(1);
        }
        catch (CodingException codingException) {
            return null;
        }
    }

    public ObjectID getPolicyQualifier() {
        return this.a;
    }

    public ASN1Object getOrganization() {
        return this.b;
    }

    public int[] getNoticeNumbers() {
        return this.c;
    }

    public ASN1Object getExplicitText() {
        return this.d;
    }

    public ASN1Object getExplicitTest() {
        return this.d;
    }

    public String getCPSuri() {
        return this.e;
    }

    private void a() {
        SEQUENCE sEQUENCE = new SEQUENCE();
        sEQUENCE.addComponent(this.a);
        if (this.a.equals(ObjectID.id_pkix_cps)) {
            sEQUENCE.addComponent(new IA5String(this.e));
        } else if (this.a.equals(ObjectID.id_pkix_unotice)) {
            SEQUENCE sEQUENCE2 = new SEQUENCE();
            if (this.b != null) {
                SEQUENCE sEQUENCE3 = new SEQUENCE();
                sEQUENCE3.addComponent(this.b);
                SEQUENCE sEQUENCE4 = new SEQUENCE();
                int n2 = 0;
                while (n2 < this.c.length) {
                    sEQUENCE4.addComponent(new INTEGER(this.c[n2]));
                    ++n2;
                }
                sEQUENCE3.addComponent(sEQUENCE4);
                sEQUENCE2.addComponent(sEQUENCE3);
            }
            if (this.d != null) {
                sEQUENCE2.addComponent(this.d);
            }
            sEQUENCE.addComponent(sEQUENCE2);
        } else {
            throw new InternalErrorException("Unknown policyQualifierId");
        }
        this.f = sEQUENCE;
    }

    public PolicyQualifierInfo(String string, int[] nArray, String string2) {
        this.a = ObjectID.id_pkix_unotice;
        if (string == null || nArray == null) {
            this.b = null;
            this.c = null;
        } else {
            this.b = new VisibleString(string);
            this.c = nArray;
        }
        this.d = new VisibleString(string2);
        this.a();
    }

    public PolicyQualifierInfo(String string) {
        this.a = ObjectID.id_pkix_cps;
        this.e = string;
        this.a();
    }

    public PolicyQualifierInfo(ASN1Object aSN1Object, int[] nArray, ASN1Object aSN1Object2) {
        this.a = ObjectID.id_pkix_unotice;
        if (aSN1Object == null || nArray == null) {
            this.b = null;
            this.c = null;
        } else if (aSN1Object.isA(ASN.BMPString) || aSN1Object.isA(ASN.VisibleString) || aSN1Object.isA(ASN.UTF8String)) {
            this.b = aSN1Object;
            this.c = nArray;
        } else {
            throw new IllegalArgumentException("Invalid ASN.1 type for organization: " + aSN1Object.getAsnType());
        }
        if (!(aSN1Object2.isA(ASN.BMPString) || aSN1Object2.isA(ASN.VisibleString) || aSN1Object2.isA(ASN.UTF8String))) {
            throw new IllegalArgumentException("Invalid ASN.1 type for explicitText: " + aSN1Object.getAsnType());
        }
        this.d = aSN1Object2;
        this.a();
    }

    public PolicyQualifierInfo(ASN1Object aSN1Object) throws CodingException {
        if (!aSN1Object.isA(ASN.SEQUENCE)) {
            throw new CodingException("No PolicyQualifierInfo!");
        }
        this.a = (ObjectID)aSN1Object.getComponentAt(0);
        this.f = aSN1Object;
        int n2 = aSN1Object.countComponents();
        if (n2 != 2) {
            throw new CodingException("Invalid number (" + n2 + ") of policyQualifierInfo components!");
        }
        if (this.a.equals(ObjectID.id_pkix_cps)) {
            this.e = (String)aSN1Object.getComponentAt(1).getValue();
            return;
        }
        if (this.a.equals(ObjectID.id_pkix_unotice)) {
            ASN1Object aSN1Object2 = aSN1Object.getComponentAt(1);
            int n3 = 0;
            while (n3 < aSN1Object2.countComponents()) {
                ASN1Object aSN1Object3 = aSN1Object2.getComponentAt(n3);
                if (aSN1Object3.isA(ASN.SEQUENCE)) {
                    this.b = aSN1Object3.getComponentAt(0);
                    ASN1Object aSN1Object4 = aSN1Object3.getComponentAt(1);
                    this.c = new int[aSN1Object4.countComponents()];
                    int n4 = 0;
                    while (n4 < aSN1Object4.countComponents()) {
                        this.c[n4] = ((BigInteger)aSN1Object4.getComponentAt(n4).getValue()).intValue();
                        ++n4;
                    }
                } else {
                    this.d = aSN1Object3;
                }
                ++n3;
            }
        }
    }
}

