/*
 * Decompiled with CFR 0.152.
 */
package ch.qos.logback.core.rolling.helper;

import ch.qos.logback.core.pattern.DynamicConverter;
import ch.qos.logback.core.pattern.FormatInfo;
import ch.qos.logback.core.rolling.helper.MonoTypedConverter;

public class IntegerTokenConverter
extends DynamicConverter<Object>
implements MonoTypedConverter {
    public static final String CONVERTER_KEY = "i";

    @Override
    public String convert(int i2) {
        String s2 = Integer.toString(i2);
        FormatInfo formattingInfo = this.getFormattingInfo();
        if (formattingInfo == null) {
            return s2;
        }
        int min = formattingInfo.getMin();
        StringBuilder sbuf = new StringBuilder();
        for (int j2 = s2.length(); j2 < min; ++j2) {
            sbuf.append('0');
        }
        return sbuf.append(s2).toString();
    }

    @Override
    public String convert(Object o2) {
        if (o2 == null) {
            throw new IllegalArgumentException("Null argument forbidden");
        }
        if (o2 instanceof Integer) {
            Integer i2 = (Integer)o2;
            return this.convert(i2);
        }
        throw new IllegalArgumentException("Cannot convert " + String.valueOf(o2) + " of type" + o2.getClass().getName());
    }

    @Override
    public boolean isApplicable(Object o2) {
        return o2 instanceof Integer;
    }
}

