/*
 * Decompiled with CFR 0.152.
 */
package ch.qos.logback.classic.pattern;

import ch.qos.logback.classic.LoggerContext;
import ch.qos.logback.classic.pattern.ExtendedThrowableProxyConverter;
import ch.qos.logback.classic.pattern.ThrowableHandlingConverter;
import ch.qos.logback.classic.pattern.ThrowableProxyConverter;
import ch.qos.logback.classic.spi.ILoggingEvent;
import ch.qos.logback.core.Context;
import ch.qos.logback.core.pattern.CompositeConverter;
import ch.qos.logback.core.pattern.Converter;
import ch.qos.logback.core.pattern.ConverterUtil;
import ch.qos.logback.core.pattern.PostCompileProcessor;

public class EnsureExceptionHandling
implements PostCompileProcessor<ILoggingEvent> {
    @Override
    public void process(Context context, Converter<ILoggingEvent> head) {
        if (head == null) {
            throw new IllegalArgumentException("cannot process empty chain");
        }
        if (!this.chainHandlesThrowable(head)) {
            Converter<ILoggingEvent> tail = ConverterUtil.findTail(head);
            ThrowableProxyConverter exConverter = null;
            LoggerContext loggerContext = (LoggerContext)context;
            exConverter = loggerContext.isPackagingDataEnabled() ? new ExtendedThrowableProxyConverter() : new ThrowableProxyConverter();
            tail.setNext(exConverter);
        }
    }

    public boolean chainHandlesThrowable(Converter<ILoggingEvent> head) {
        for (Converter<ILoggingEvent> c2 = head; c2 != null; c2 = c2.getNext()) {
            if (c2 instanceof ThrowableHandlingConverter) {
                return true;
            }
            if (!(c2 instanceof CompositeConverter) || !this.compositeHandlesThrowable((CompositeConverter)c2)) continue;
            return true;
        }
        return false;
    }

    public boolean compositeHandlesThrowable(CompositeConverter<ILoggingEvent> compositeConverter) {
        Converter<ILoggingEvent> childConverter;
        for (Converter<ILoggingEvent> c2 = childConverter = compositeConverter.getChildConverter(); c2 != null; c2 = c2.getNext()) {
            boolean r2;
            if (c2 instanceof ThrowableHandlingConverter) {
                return true;
            }
            if (!(c2 instanceof CompositeConverter) || !(r2 = this.compositeHandlesThrowable((CompositeConverter)c2))) continue;
            return true;
        }
        return false;
    }
}

