/*
 * Decompiled with CFR 0.152.
 */
package iaik.x509.ocsp;

import iaik.asn1.ASN1Object;
import iaik.asn1.BOOLEAN;
import iaik.asn1.CodingException;
import iaik.asn1.DerCoder;
import iaik.asn1.OCTET_STRING;
import iaik.asn1.ObjectID;
import iaik.asn1.SEQUENCE;
import iaik.utils.InternalErrorException;
import iaik.x509.UnknownExtension;
import iaik.x509.V3Extension;
import iaik.x509.X509ExtensionException;
import iaik.x509.X509ExtensionInitException;
import iaik.x509.X509Extensions;
import iaik.x509.ocsp.extensions.AcceptableResponses;
import iaik.x509.ocsp.extensions.ArchiveCutoff;
import iaik.x509.ocsp.extensions.CrlID;
import iaik.x509.ocsp.extensions.Nonce;
import iaik.x509.ocsp.extensions.ServiceLocator;
import java.util.Enumeration;

public class OCSPExtensions
extends X509Extensions {
    static /* synthetic */ Class a;
    static /* synthetic */ Class b;
    static /* synthetic */ Class c;
    static /* synthetic */ Class d;
    static /* synthetic */ Class e;

    static Class a(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    public ASN1Object toASN1Object() throws X509ExtensionException {
        Object object;
        Object object2;
        Object object3;
        SEQUENCE sEQUENCE = null;
        SEQUENCE sEQUENCE2 = null;
        sEQUENCE2 = new SEQUENCE();
        Enumeration enumeration = this.critical_extensions.keys();
        while (enumeration.hasMoreElements()) {
            sEQUENCE = new SEQUENCE();
            object3 = (ObjectID)enumeration.nextElement();
            sEQUENCE.addComponent((ASN1Object)object3);
            sEQUENCE.addComponent(new BOOLEAN(true));
            object2 = (byte[])this.critical_extensions.get(object3);
            if (object2 == null) {
                throw new InternalErrorException("Extension value = null!");
            }
            if (((ObjectID)object3).equals(Nonce.oid)) {
                try {
                    object = DerCoder.decode((byte[])object2);
                    sEQUENCE.addComponent((ASN1Object)object);
                }
                catch (CodingException codingException) {
                    throw new X509ExtensionException("Cannot add Nonce extension: Invalid Encoding: " + codingException.getMessage());
                }
            } else {
                sEQUENCE.addComponent(new OCTET_STRING((byte[])object2));
            }
            sEQUENCE2.addComponent(sEQUENCE);
        }
        object3 = this.noncritical_extensions.keys();
        while (object3.hasMoreElements()) {
            sEQUENCE = new SEQUENCE();
            object2 = (ObjectID)object3.nextElement();
            sEQUENCE.addComponent((ASN1Object)object2);
            object = (byte[])this.noncritical_extensions.get(object2);
            if (object == null) {
                throw new InternalErrorException("Extension value = null!");
            }
            if (((ObjectID)object2).equals(Nonce.oid)) {
                try {
                    ASN1Object aSN1Object = DerCoder.decode(object);
                    sEQUENCE.addComponent(aSN1Object);
                }
                catch (CodingException codingException) {
                    throw new X509ExtensionException("Cannot add Nonce extension: Invalid Encoding: " + codingException.getMessage());
                }
            } else {
                sEQUENCE.addComponent(new OCTET_STRING((byte[])object));
            }
            sEQUENCE2.addComponent(sEQUENCE);
        }
        return sEQUENCE2;
    }

    public V3Extension getExtension(ObjectID objectID) throws X509ExtensionInitException {
        boolean bl = true;
        byte[] byArray = (byte[])this.critical_extensions.get(objectID);
        if (byArray == null) {
            byArray = (byte[])this.noncritical_extensions.get(objectID);
            if (byArray == null) {
                return null;
            }
            bl = false;
        }
        V3Extension v3Extension = null;
        try {
            v3Extension = X509Extensions.create(objectID);
        }
        catch (InstantiationException instantiationException) {
            v3Extension = new UnknownExtension(objectID);
        }
        v3Extension.setCritical(bl);
        try {
            if (objectID.equals(Nonce.oid)) {
                v3Extension.init(new OCTET_STRING(byArray));
            } else {
                ASN1Object aSN1Object = DerCoder.decode(byArray);
                v3Extension.init(aSN1Object);
            }
        }
        catch (X509ExtensionException x509ExtensionException) {
            throw new X509ExtensionInitException(objectID, bl, x509ExtensionException.toString());
        }
        catch (CodingException codingException) {
            throw new X509ExtensionInitException(objectID, bl, codingException.toString());
        }
        return v3Extension;
    }

    public OCSPExtensions(ASN1Object aSN1Object) throws X509ExtensionException {
        super(aSN1Object);
    }

    public OCSPExtensions() {
    }

    static {
        X509Extensions.register(AcceptableResponses.oid, e != null ? e : (e = OCSPExtensions.a("iaik.x509.ocsp.extensions.AcceptableResponses")));
        X509Extensions.register(ArchiveCutoff.oid, d != null ? d : (d = OCSPExtensions.a("iaik.x509.ocsp.extensions.ArchiveCutoff")));
        X509Extensions.register(CrlID.oid, c != null ? c : (c = OCSPExtensions.a("iaik.x509.ocsp.extensions.CrlID")));
        X509Extensions.register(Nonce.oid, b != null ? b : (b = OCSPExtensions.a("iaik.x509.ocsp.extensions.Nonce")));
        X509Extensions.register(ServiceLocator.oid, a != null ? a : (a = OCSPExtensions.a("iaik.x509.ocsp.extensions.ServiceLocator")));
    }
}

