/*
 * Decompiled with CFR 0.152.
 */
package iaik.x509;

import iaik.asn1.ASN;
import iaik.asn1.ASN1;
import iaik.asn1.ASN1Object;
import iaik.asn1.ASN1Type;
import iaik.asn1.BIT_STRING;
import iaik.asn1.CON_SPEC;
import iaik.asn1.CodingException;
import iaik.asn1.ConstructedType;
import iaik.asn1.DerCoder;
import iaik.asn1.INTEGER;
import iaik.asn1.ObjectID;
import iaik.asn1.SEQUENCE;
import iaik.asn1.structures.AlgorithmID;
import iaik.asn1.structures.ChoiceOfTime;
import iaik.asn1.structures.GeneralName;
import iaik.asn1.structures.GeneralNames;
import iaik.asn1.structures.Name;
import iaik.utils.ConcatEnumeration;
import iaik.x509.RevokedCertificate;
import iaik.x509.V3Extension;
import iaik.x509.X509Certificate;
import iaik.x509.X509ExtensionException;
import iaik.x509.X509ExtensionInitException;
import iaik.x509.X509Extensions;
import iaik.x509.extensions.CertificateIssuer;
import iaik.x509.extensions.ReasonCode;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.math.BigInteger;
import java.security.InvalidKeyException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.Principal;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.Signature;
import java.security.SignatureException;
import java.security.cert.CRLException;
import java.security.cert.Certificate;
import java.security.cert.X509CRLEntry;
import java.util.Date;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Set;
import java.util.Vector;

public class X509CRL
extends java.security.cert.X509CRL
implements ASN1Type {
    private byte[] l;
    private boolean i;
    private boolean c;
    private X509Extensions j;
    private Hashtable f;
    private byte[] e;
    private ChoiceOfTime g;
    private ChoiceOfTime b;
    private Name h;
    private AlgorithmID d;
    private int a = 1;
    private ASN1 k = new ASN1();

    public void writeTo(OutputStream outputStream) throws IOException {
        this.d();
        this.k.writeTo(outputStream);
    }

    public void verify(PublicKey publicKey, String string) throws SignatureException, NoSuchProviderException, InvalidKeyException, NoSuchAlgorithmException, CRLException {
        this.d();
        if (this.d == null) {
            throw new NoSuchAlgorithmException("Cannot verify crl! No signature algorithm set.");
        }
        Signature signature = this.d.getSignatureInstance(string);
        try {
            byte[] byArray = this.k.getFirstObject();
            signature.initVerify(publicKey);
            signature.update(byArray);
        }
        catch (CodingException codingException) {
            throw new SignatureException(codingException.toString());
        }
        if (!signature.verify(this.e)) {
            throw new SignatureException("Signature verification error!");
        }
    }

    public void verify(PublicKey publicKey) throws SignatureException, NoSuchProviderException, InvalidKeyException, NoSuchAlgorithmException, CRLException {
        this.verify(publicKey, (String)null);
    }

    public String toString(boolean bl) {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("X509 version " + this.a + " CRL\n");
        stringBuffer.append("Signature Algorithm: " + this.d.getName() + "\n");
        stringBuffer.append("Issuer: " + this.h.toString() + "\n");
        stringBuffer.append("this update: " + this.b.toString() + "\n");
        if (this.g != null) {
            stringBuffer.append("next update: " + this.g.toString() + "\n");
        }
        if (this.j != null) {
            if (bl) {
                stringBuffer.append(this.j);
            } else {
                stringBuffer.append("Extensions: " + this.j.countExtensions() + "\n");
            }
        }
        if (bl) {
            int n2 = 1;
            Enumeration enumeration = this.listCertificates();
            while (enumeration.hasMoreElements()) {
                RevokedCertificate revokedCertificate = (RevokedCertificate)enumeration.nextElement();
                stringBuffer.append(String.valueOf(n2) + ": " + revokedCertificate.toString(bl) + "\n");
                ++n2;
            }
        } else {
            Enumeration enumeration = this.f.keys();
            while (enumeration.hasMoreElements()) {
                Name name = (Name)enumeration.nextElement();
                Hashtable hashtable = (Hashtable)this.f.get(name);
                stringBuffer.append(String.valueOf(name.toString()) + ": " + hashtable.size() + " revoked certificates\n");
            }
        }
        return stringBuffer.toString();
    }

    public String toString() {
        return this.toString(false);
    }

    public byte[] toByteArray() {
        this.d();
        return this.k.toByteArray();
    }

    public ASN1Object toASN1Object() {
        this.d();
        return this.k.toASN1Object();
    }

    public void sign(PrivateKey privateKey, String string) throws NoSuchAlgorithmException, InvalidKeyException, CRLException {
        Object object;
        BIT_STRING bIT_STRING = null;
        ASN1Object aSN1Object = this.a();
        try {
            object = this.d.getSignatureInstance(string);
            ((Signature)object).initSign(privateKey);
            ((Signature)object).update(DerCoder.encode(aSN1Object));
            this.e = ((Signature)object).sign();
            bIT_STRING = new BIT_STRING(this.e);
        }
        catch (SignatureException signatureException) {
            throw new CRLException(signatureException.toString());
        }
        try {
            object = null;
            object = new SEQUENCE();
            ((ConstructedType)object).addComponent(aSN1Object);
            ((ConstructedType)object).addComponent(this.d.toASN1Object());
            ((ConstructedType)object).addComponent(bIT_STRING);
            this.k = new ASN1((ASN1Object)object);
        }
        catch (CodingException codingException) {
            throw new CRLException(codingException.toString());
        }
        this.e();
        this.f();
    }

    public void sign(PrivateKey privateKey) throws NoSuchAlgorithmException, InvalidKeyException, CRLException {
        this.sign(privateKey, null);
    }

    public void setThisUpdate(Date date) {
        this.b = new ChoiceOfTime(date, true);
        this.e();
    }

    private void f() {
        this.i = false;
    }

    public void setSignatureAlgorithm(AlgorithmID algorithmID) {
        if (algorithmID == null) {
            throw new NullPointerException("Cannot set null signature algorithm for this CRL!");
        }
        this.d = algorithmID;
    }

    public void setSignatureAlgorithm(ObjectID objectID) {
        this.setSignatureAlgorithm(new AlgorithmID(objectID));
    }

    public void setSignature(byte[] byArray) throws CRLException {
        if (byArray == null) {
            throw new CRLException("Cannot sign crl. No signature value specified!");
        }
        this.e = byArray;
        ASN1Object aSN1Object = this.a();
        BIT_STRING bIT_STRING = new BIT_STRING(this.e);
        try {
            SEQUENCE sEQUENCE = null;
            sEQUENCE = new SEQUENCE();
            sEQUENCE.addComponent(aSN1Object);
            sEQUENCE.addComponent(this.d.toASN1Object());
            sEQUENCE.addComponent(bIT_STRING);
            this.k = new ASN1(sEQUENCE);
        }
        catch (CodingException codingException) {
            throw new CRLException(codingException.toString());
        }
        this.e();
        this.f();
    }

    public void setNextUpdate(Date date) {
        this.g = new ChoiceOfTime(date, true);
        this.e();
    }

    private void e() {
        this.i = true;
        this.l = null;
    }

    public void setIssuerDN(Principal principal) throws IllegalArgumentException {
        try {
            this.h = (Name)principal;
            this.e();
            return;
        }
        catch (Exception exception) {
            throw new IllegalArgumentException("Issuer is not an instance of name.");
        }
    }

    public boolean removeExtension(ObjectID objectID) {
        boolean bl = false;
        boolean bl2 = bl = this.j == null ? false : this.j.removeExtension(objectID);
        if (bl) {
            this.e();
        }
        return bl;
    }

    private boolean a(Principal principal, BigInteger bigInteger) {
        Hashtable hashtable = this.a(principal, false);
        if (hashtable != null && hashtable.remove(bigInteger) != null) {
            this.e();
            return true;
        }
        return false;
    }

    public boolean removeCertificate(BigInteger bigInteger) {
        return this.a((Principal)this.h, bigInteger);
    }

    public boolean removeCertificate(X509Certificate x509Certificate) {
        return this.a(x509Certificate.getIssuerDN(), x509Certificate.getSerialNumber());
    }

    public void removeAllExtensions() {
        if (this.j != null) {
            this.j.removeAllExtensions();
            this.e();
        }
    }

    public void removeAllCertificates() {
        this.f.clear();
        this.e();
    }

    private void a(ASN1Object aSN1Object) throws CRLException, CodingException {
        int n2 = aSN1Object.countComponents();
        Hashtable hashtable = new Hashtable();
        this.f.put(this.h, hashtable);
        int n3 = 0;
        while (n3 < n2) {
            RevokedCertificate revokedCertificate = new RevokedCertificate(aSN1Object.getComponentAt(n3));
            this.c |= revokedCertificate.hasUnsupportedCriticalExtension();
            Name name = X509CRL.a(revokedCertificate);
            if (name != null) {
                hashtable = this.a((Principal)name, true);
            }
            hashtable.put(revokedCertificate.getSerialNumber(), revokedCertificate);
            ++n3;
        }
    }

    public Enumeration listExtensions() {
        if (this.j == null) {
            return null;
        }
        return this.j.listExtensions();
    }

    public Enumeration listCertificates() {
        Vector vector = new Vector();
        Enumeration enumeration = this.f.elements();
        while (enumeration.hasMoreElements()) {
            Hashtable hashtable = (Hashtable)enumeration.nextElement();
            vector.addElement(hashtable.elements());
        }
        return new ConcatEnumeration(vector.elements());
    }

    public boolean isRevoked(Certificate certificate) {
        if (!(certificate instanceof X509Certificate)) {
            throw new IllegalArgumentException("Certificate must be instance of iaik.x509.X509Certificate");
        }
        return this.b(this.containsCertificate((X509Certificate)certificate));
    }

    public boolean isRevoked(BigInteger bigInteger) {
        return this.b(this.containsCertificate(bigInteger));
    }

    private boolean b(RevokedCertificate revokedCertificate) {
        if (revokedCertificate == null) {
            return false;
        }
        try {
            ReasonCode reasonCode = (ReasonCode)revokedCertificate.getExtension(ReasonCode.oid);
            if (reasonCode != null && reasonCode.getReasonCode() == 8) {
                return false;
            }
        }
        catch (X509ExtensionInitException x509ExtensionInitException) {}
        return true;
    }

    public boolean isIndirectCRL() {
        Enumeration enumeration = this.f.keys();
        while (enumeration.hasMoreElements()) {
            Hashtable hashtable;
            Name name = (Name)enumeration.nextElement();
            if (name.equals(this.h) || (hashtable = (Hashtable)this.f.get(name)).size() <= 0) continue;
            return true;
        }
        return false;
    }

    private void c() throws CRLException {
        int n2 = 0;
        try {
            ASN1Object aSN1Object = this.k.getComponentAt(0);
            AlgorithmID algorithmID = new AlgorithmID(this.k.getComponentAt(1));
            ASN1Object aSN1Object2 = this.k.getComponentAt(2);
            this.e = (byte[])((BIT_STRING)aSN1Object2).getValue();
            ASN1Object aSN1Object3 = aSN1Object.getComponentAt(n2);
            if (aSN1Object3.isA(ASN.INTEGER)) {
                BigInteger bigInteger = (BigInteger)aSN1Object3.getValue();
                this.a = bigInteger.intValue() + 1;
            }
            int n3 = ++n2;
            ++n2;
            this.d = new AlgorithmID(aSN1Object.getComponentAt(n3));
            if (!algorithmID.equals(this.d)) {
                throw new CRLException("CRL signature algorithm mismatch");
            }
            this.h = new Name(aSN1Object.getComponentAt(n2++));
            this.b = new ChoiceOfTime(aSN1Object.getComponentAt(n2++));
            while (n2 < aSN1Object.countComponents()) {
                if ((aSN1Object3 = aSN1Object.getComponentAt(n2++)).isA(ASN.SEQUENCE)) {
                    this.a(aSN1Object3);
                    continue;
                }
                if (aSN1Object3.isA(ASN.CON_SPEC)) {
                    if (aSN1Object3.getAsnType().getTag() == 0) {
                        this.j = new X509Extensions((ASN1Object)aSN1Object3.getValue());
                        continue;
                    }
                    throw new CRLException("Unknown CRL format.");
                }
                if (aSN1Object3.isA(ASN.UTCTime) || aSN1Object3.isA(ASN.GeneralizedTime)) {
                    this.g = new ChoiceOfTime(aSN1Object3);
                    continue;
                }
                throw new CRLException("Unknown CRL format.");
            }
            this.k.clearASN1Object();
            this.f();
            return;
        }
        catch (RuntimeException runtimeException) {
            throw new CRLException("CRL format error: " + runtimeException.toString());
        }
        catch (X509ExtensionException x509ExtensionException) {
            throw new CRLException("CRL format error: " + x509ExtensionException.toString());
        }
        catch (CodingException codingException) {
            throw new CRLException("CRL format error: " + codingException.toString());
        }
    }

    public boolean hasUnsupportedCriticalExtension() {
        if (this.c) {
            return true;
        }
        if (this.j == null) {
            return false;
        }
        return this.j.hasUnsupportedCriticalExtension();
    }

    public boolean hasExtensions() {
        if (this.j == null) {
            return false;
        }
        return this.j.hasExtensions();
    }

    public int getVersion() {
        return this.a;
    }

    public Date getThisUpdate() {
        return this.b.getDate();
    }

    public byte[] getTBSCertList() throws CRLException {
        try {
            if (this.k != null && this.k.toByteArray() != null) {
                return this.k.getFirstObject();
            }
            return DerCoder.encode(this.a());
        }
        catch (CodingException codingException) {
            throw new CRLException(codingException.toString());
        }
    }

    public AlgorithmID getSignatureAlgorithm() {
        return this.d;
    }

    public byte[] getSignature() {
        return this.e;
    }

    public byte[] getSigAlgParams() {
        try {
            ASN1Object aSN1Object = this.d.getParameter();
            if (aSN1Object == null) {
                return null;
            }
            return new ASN1(aSN1Object).toByteArray();
        }
        catch (CodingException codingException) {
            throw new RuntimeException(codingException.toString());
        }
    }

    public String getSigAlgOID() {
        return this.d.getAlgorithm().getID();
    }

    public String getSigAlgName() {
        return this.d.getName();
    }

    public Set getRevokedCertificates() {
        HashSet<RevokedCertificate> hashSet = new HashSet<RevokedCertificate>();
        Enumeration enumeration = this.listCertificates();
        while (enumeration.hasMoreElements()) {
            RevokedCertificate revokedCertificate = (RevokedCertificate)enumeration.nextElement();
            hashSet.add(revokedCertificate);
        }
        return hashSet;
    }

    public X509CRLEntry getRevokedCertificate(BigInteger bigInteger) {
        return this.containsCertificate(bigInteger);
    }

    public Set getNonCriticalExtensionOIDs() {
        if (this.j == null) {
            return null;
        }
        return this.j.getNonCriticalExtensionOIDs();
    }

    public Date getNextUpdate() {
        if (this.g == null) {
            return null;
        }
        return this.g.getDate();
    }

    private Hashtable a(Principal principal, boolean bl) {
        Hashtable hashtable = (Hashtable)this.f.get((Name)principal);
        if (hashtable == null && bl) {
            hashtable = new Hashtable();
            this.f.put(principal, hashtable);
        }
        return hashtable;
    }

    public Enumeration getIssuerDNs() {
        this.a((Principal)this.h, true);
        return this.f.keys();
    }

    public Principal getIssuerDN() {
        return this.h;
    }

    private static Name a(RevokedCertificate revokedCertificate) throws CRLException {
        try {
            CertificateIssuer certificateIssuer = (CertificateIssuer)revokedCertificate.getExtension(CertificateIssuer.oid);
            if (certificateIssuer == null) {
                return null;
            }
            GeneralNames generalNames = certificateIssuer.getIssuer();
            Enumeration enumeration = generalNames.getNames();
            while (enumeration.hasMoreElements()) {
                GeneralName generalName = (GeneralName)enumeration.nextElement();
                if (generalName.getType() != 4) continue;
                Name name = (Name)generalName.getName();
                return name;
            }
            throw new CRLException("Only certificate issuer extensions contains a directory name supported");
        }
        catch (X509ExtensionInitException x509ExtensionInitException) {
            throw new CRLException(x509ExtensionInitException.toString());
        }
    }

    public byte[] getFingerprintSHA() {
        if (this.l == null) {
            try {
                this.l = this.getFingerprint("SHA");
            }
            catch (NoSuchAlgorithmException noSuchAlgorithmException) {
                throw new RuntimeException("Algorithm SHA not available: " + noSuchAlgorithmException.toString());
            }
        }
        return this.l;
    }

    public byte[] getFingerprint(String string) throws NoSuchAlgorithmException {
        this.d();
        MessageDigest messageDigest = MessageDigest.getInstance(string);
        messageDigest.update(this.toByteArray());
        return messageDigest.digest();
    }

    public byte[] getFingerprint() {
        this.d();
        return this.k.fingerprint();
    }

    public byte[] getExtensionValue(String string) {
        if (this.j == null) {
            return null;
        }
        return this.j.getExtensionValue(string);
    }

    public V3Extension getExtension(ObjectID objectID) throws X509ExtensionInitException {
        if (this.j == null) {
            return null;
        }
        return this.j.getExtension(objectID);
    }

    public byte[] getEncoded() throws CRLException {
        this.d();
        return this.toByteArray();
    }

    public Set getCriticalExtensionOIDs() {
        if (this.j == null) {
            return null;
        }
        return this.j.getCriticalExtensionOIDs();
    }

    public void decode(ASN1Object aSN1Object) throws CodingException {
        this.k = new ASN1(aSN1Object);
        try {
            this.c();
            return;
        }
        catch (CRLException cRLException) {
            throw new CodingException(cRLException.toString());
        }
    }

    private ASN1Object b() throws X509ExtensionException, CRLException {
        SEQUENCE sEQUENCE = new SEQUENCE();
        if (!this.isIndirectCRL()) {
            Enumeration enumeration = this.a((Principal)this.h, false).elements();
            while (enumeration.hasMoreElements()) {
                sEQUENCE.addComponent(((RevokedCertificate)enumeration.nextElement()).toASN1Object());
            }
        } else {
            Enumeration enumeration = this.f.keys();
            while (enumeration.hasMoreElements()) {
                Name name = (Name)enumeration.nextElement();
                Hashtable hashtable = this.a((Principal)name, false);
                boolean bl = true;
                Enumeration enumeration2 = hashtable.elements();
                while (enumeration2.hasMoreElements()) {
                    RevokedCertificate revokedCertificate = (RevokedCertificate)enumeration2.nextElement();
                    if (bl) {
                        bl = false;
                        GeneralNames generalNames = new GeneralNames(new GeneralName(4, name));
                        CertificateIssuer certificateIssuer = new CertificateIssuer(generalNames);
                        certificateIssuer.setCritical(true);
                        revokedCertificate.addExtension(certificateIssuer);
                    } else {
                        revokedCertificate.removeExtension(CertificateIssuer.oid);
                    }
                    sEQUENCE.addComponent(revokedCertificate.toASN1Object());
                }
            }
        }
        return sEQUENCE;
    }

    private ASN1Object a() throws CRLException {
        this.a = 1;
        SEQUENCE sEQUENCE = null;
        if (this.d == null) {
            throw new CRLException("Signature algorithm not set!");
        }
        if (this.h == null) {
            throw new CRLException("Issuer not set!");
        }
        if (this.b == null) {
            throw new CRLException("ThisUpdate not set!");
        }
        if (this.j != null) {
            this.a = 2;
        }
        try {
            sEQUENCE = new SEQUENCE();
            if (this.a > 1) {
                sEQUENCE.addComponent(new INTEGER(this.a - 1));
            }
            sEQUENCE.addComponent(this.d.toASN1Object());
            sEQUENCE.addComponent(this.h.toASN1Object());
            sEQUENCE.addComponent(this.b.toASN1Object());
            if (this.g != null) {
                sEQUENCE.addComponent(this.g.toASN1Object());
            }
            if (this.f.size() > 0) {
                sEQUENCE.addComponent(this.b());
            }
            if (this.j != null) {
                CON_SPEC cON_SPEC = new CON_SPEC(0, this.j.toASN1Object());
                sEQUENCE.addComponent(cON_SPEC);
            }
            return sEQUENCE;
        }
        catch (X509ExtensionException x509ExtensionException) {
            throw new CRLException(x509ExtensionException.toString());
        }
    }

    public int countExtensions() {
        if (this.j == null) {
            return 0;
        }
        return this.j.countExtensions();
    }

    public RevokedCertificate containsCertificate(BigInteger bigInteger) {
        Hashtable hashtable = this.a((Principal)this.h, false);
        if (hashtable == null) {
            return null;
        }
        return (RevokedCertificate)hashtable.get(bigInteger);
    }

    public RevokedCertificate containsCertificate(X509Certificate x509Certificate) {
        Hashtable hashtable = this.a(x509Certificate.getIssuerDN(), false);
        if (hashtable == null) {
            return null;
        }
        return (RevokedCertificate)hashtable.get(x509Certificate.getSerialNumber());
    }

    private void d() {
        if (this.i) {
            throw new RuntimeException("Cannot perform operation, CRL has to be signed first");
        }
    }

    public void addExtension(V3Extension v3Extension) throws X509ExtensionException {
        if (this.j == null) {
            this.j = new X509Extensions();
        }
        this.j.addExtension(v3Extension);
        this.e();
    }

    public void addCertificate(X509Certificate x509Certificate, Date date) {
        Hashtable hashtable = this.a(x509Certificate.getIssuerDN(), true);
        hashtable.put(x509Certificate.getSerialNumber(), new RevokedCertificate(x509Certificate, date));
        this.e();
    }

    public void addCertificate(RevokedCertificate revokedCertificate) {
        try {
            Name name = X509CRL.a(revokedCertificate);
            if (name == null && (name = this.h) == null) {
                throw new NullPointerException("CRL issuer must be set before adding a revoked certificate");
            }
            Hashtable hashtable = this.a((Principal)name, true);
            hashtable.put(revokedCertificate.getSerialNumber(), (RevokedCertificate)revokedCertificate.clone());
            this.e();
            return;
        }
        catch (CRLException cRLException) {
            throw new IllegalArgumentException(cRLException.toString());
        }
    }

    public X509CRL(byte[] byArray) throws CRLException {
        this();
        try {
            this.k = new ASN1(byArray);
        }
        catch (CodingException codingException) {
            throw new CRLException(codingException.toString());
        }
        this.c();
    }

    public X509CRL(InputStream inputStream) throws CRLException, IOException {
        this();
        try {
            this.k = new ASN1(inputStream);
        }
        catch (CodingException codingException) {
            throw new CRLException(codingException.toString());
        }
        this.c();
    }

    public X509CRL() {
        this.f = new Hashtable(10);
        this.e();
    }
}

