/*
 * Decompiled with CFR 0.152.
 */
package iaik.asn1.structures;

import iaik.asn1.ASN;
import iaik.asn1.ASN1Object;
import iaik.asn1.ASN1Type;
import iaik.asn1.CodingException;
import iaik.asn1.ObjectID;
import iaik.asn1.SEQUENCE;
import iaik.asn1.structures.GeneralName;

public class AccessDescription
implements ASN1Type {
    private GeneralName b;
    private ObjectID a;

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("accessMethod: ");
        stringBuffer.append(this.a == null ? "null" : this.a.toString());
        stringBuffer.append("\naccessLocation: ");
        stringBuffer.append(this.b == null ? "null" : this.b.toString());
        stringBuffer.append("\n");
        return stringBuffer.toString();
    }

    public ASN1Object toASN1Object() throws CodingException {
        SEQUENCE sEQUENCE = new SEQUENCE();
        if (this.a == null || this.b == null) {
            throw new CodingException("Cannot create ASN.1 object for this AccessDescription! Not enough information available!");
        }
        sEQUENCE.addComponent(this.a);
        sEQUENCE.addComponent(this.b.toASN1Object());
        return sEQUENCE;
    }

    public void setAccessMethod(ObjectID objectID) throws IllegalArgumentException {
        if (objectID == null) {
            throw new IllegalArgumentException("Cannot set null accessMethod!");
        }
        this.a = objectID;
    }

    public void setAccessLocation(GeneralName generalName) throws IllegalArgumentException {
        if (generalName == null) {
            throw new IllegalArgumentException("Cannot set null access location!");
        }
        this.b = generalName;
    }

    public ObjectID getAccessMethod() {
        return this.a;
    }

    public GeneralName getAccessLocation() {
        return this.b;
    }

    public void decode(ASN1Object aSN1Object) throws CodingException {
        try {
            if (!aSN1Object.isA(ASN.SEQUENCE)) {
                throw new CodingException("Cannot parse AccessDescription! Has to be a SEQUENCE!");
            }
            SEQUENCE sEQUENCE = (SEQUENCE)aSN1Object;
            if (sEQUENCE.countComponents() != 2) {
                throw new CodingException("Cannot parse AccessDescription! Wrong number of components!");
            }
            ASN1Object aSN1Object2 = sEQUENCE.getComponentAt(0);
            if (!aSN1Object2.isA(ASN.ObjectID)) {
                throw new CodingException("Cannot parse AccessDescription! First component has to be an ObjectID!");
            }
            this.a = (ObjectID)aSN1Object2;
            aSN1Object2 = sEQUENCE.getComponentAt(1);
            this.b = new GeneralName(aSN1Object2);
            return;
        }
        catch (Exception exception) {
            throw new CodingException(exception.toString());
        }
    }

    public AccessDescription(ObjectID objectID, GeneralName generalName) throws IllegalArgumentException {
        if (objectID == null) {
            throw new IllegalArgumentException("Cannot create AccessDescription! No accessMethod specified!");
        }
        if (generalName == null) {
            throw new IllegalArgumentException("Cannot create AccessDescription! No accessLocation specified!");
        }
        this.a = objectID;
        this.b = generalName;
    }

    public AccessDescription(ASN1Object aSN1Object) throws CodingException {
        this.decode(aSN1Object);
    }

    public AccessDescription() {
    }
}

